/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.util;

import de.willuhn.io.FileFinder;
import de.willuhn.logging.Logger;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;

public class JarLoader {
    public static void loadJars(File dir) throws IOException {
        File[] jars;
        if (!(dir.exists() && dir.isDirectory() && dir.canRead())) {
            throw new IOException("unable to read dir " + dir);
        }
        FileFinder finder = new FileFinder(dir);
        finder.extension(".jar");
        for (File jar : jars = finder.findRecursive()) {
            JarLoader.loadJar(jar);
        }
    }

    public static void loadJar(File jar) throws IOException {
        if (!jar.isFile() || !jar.canRead()) {
            throw new IOException("unable to read file " + jar);
        }
        try {
            URLClassLoader loader = (URLClassLoader)ClassLoader.getSystemClassLoader();
            Method method = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
            method.setAccessible(true);
            Logger.debug("loading " + jar);
            method.invoke((Object)loader, jar.toURI().toURL());
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (Exception e) {
            throw new IOException("unable to load jar " + jar + ": " + e.getMessage());
        }
    }
}

